#!%perl%

#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################

#########################################################
#                                                       #
#  Color preview script                                 #
#                                                       #
#########################################################




#-------------------------! do not edit below here !---------------------------

use strict;
my (
	%cgi,
	$out,
);
getcgi_simple();

print "Content-type: text/html\n\n";

if ($cgi{type} eq "color") {
	if ($cgi{content} !~ /^[0-9a-f]{6}$/i) {
		$out = <<"		EOT";
		<html>
		<head>
			<title>ColorPreview</title>
		</head>
		<body bgcolor="#ffffff" text="#000000">
		<div align=center>
		<font face="Arial, sans-serif" size=1>
		<b>Preview color:</b><br>
		<form action="preview.cgi" method=get>
		<input type=hidden name=type value=color>
		#<input type=text name=content size=6 maxlength=6>
		<input type=submit value=Go></form>
		</div>
		</body></html>
		EOT
	} else {
		my @asccodes;
		while ($cgi{content} =~ /([a-f0-9]{2})/gi) {
			push(@asccodes, hex($1));
		}
		my $text = join("", map { sprintf("%02X", (255 - $_)) } @asccodes);
		$out = <<"		EOT";
		<html>
		<head>
			<title>#$cgi{content}</title>
		</head>
		<body bgcolor="#$cgi{content}" link="#$text" vlink="#$text">
		<center><br>
		<font face="Arial, sans-serif" size=3><b>
		<a href="javascript:window.history.go(-1)">BACK</a>
		</body>
		</html>
		EOT
	}
}
elsif ($cgi{type}) {
	err("bad type: $cgi{type}");
}
else {
	err("no type to preview specified");
}

$out =~ s/^\t+//gm;
print $out;



sub	err {
	print "<pre>ERROR:\n\n  $_[0]\n</pre>\n";
	exit;
}


sub	getcgi_simple {
	my $query = $ENV{QUERY_STRING};
	foreach (split(/&/, $query)) {
		$query =~ tr/+/ /;
		my ($item, $value) = split(/=/);
		$item 	=~ s/%([a-f0-9]{2})/pack("C", hex($1))/egi;
		$value 	=~ s/%([a-f0-9]{2})/pack("C", hex($1))/egi;
		$cgi{$item} = $value;
	}
}
